#include <stdio.h>
#include <stdlib.h>
#include <math.h>

struct list_t {
  double val;
  struct list_t *ptr;
};

int main(int argc, char **argv) {
  struct list_t *phead, *pnext, *p, x;
  int i, count;
  char buffer[64];
  double sum=0, product=1, logsum=0;
  double mean, geomean, loggeomean;

  phead=NULL;
  count=0;

  if (argc==1) {
    printf("Enter values, terminate with Ctrl-D:\n");
  }
  while (fgets(buffer, 63, stdin) != NULL) {
    count++;
    if (p = malloc(sizeof(struct list_t))) {
      p->ptr = phead;
      p->val = strtod(buffer, NULL);
      phead = p;
    } else {
      perror("Out of memory!");
      return EXIT_FAILURE;
    }
  }

  printf("Arithmetic and Geometric Mean\n\n");
  printf("Count :\t%d\n", count);
  printf("Values:\n");
  while (phead) {
    printf("\t%lf\n", phead->val);
    sum += phead->val;
    product *= phead->val;
    logsum += log(phead->val);
    p = phead;
    phead = p->ptr;
    free(p);
  }
  printf("\n");
  printf("Sum             : %lf\n", sum);
  printf("Average         : %lf\n", sum/count);
  printf("\n");
  printf("Product         : %lf\n", product);
  printf("Geometric mean  : %lf\n", pow(product,1.0/count));
  printf("\n");
  printf("Sum of Logs     : %lf\n", logsum);
  printf("Geo. mean w/logs: %lf\n", exp(logsum/count));
  printf("\n");
    
  return EXIT_SUCCESS;
}
